/*====================================+=====================================+
! File CCompletion.h                  ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CCOMPLETION_H
#define CCOMPLETION_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <vector>
#include "CCombo.h"
#include "common/CListCtrlBase.h"
/*-------------------------------------------------------------------------*/
class CCompletion ;
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CCompletionList : public CListCtrlBase
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CCompletionList( wxWindow *parent, CCompletion *p_completion,
                       const wxString &s_def_help_file
                     ) ;
      //~CCompletionList() ;
      /*-------------------------------------------------------------------*/
      void OnKeyDown( wxKeyEvent &event ) ;
      void OnItemRightClick( wxListEvent &event ) ;
      void OnItemActivated( wxListEvent &event ) ;
      void show_help_for_current_item() ;
      long search_for( const wxString &s ) const ;

   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      CCompletion *m_p_completion ;
      wxString    m_s_def_help_file ;
      /*-------------------------------------------------------------------*/
      DECLARE_EVENT_TABLE()

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CCompletion : public wxFrame
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CCompletion( CCombo *p_combo, wxToolBarToolBase *p_to_btn,
                   wxMenuItem *p_menu_item,
                   const wxString &s_title,
                   CCompletion *&p_saved_addr, CConfigRect &cfg_rec
                 ) ;
      CCompletion( wxTextCtrl *p_textctrl, wxToolBarToolBase *p_to_btn,
                   wxMenuItem *p_menu_item,
                   const wxString &s_title,
                   CCompletion *&p_saved_addr, CConfigRect &cfg_rec
                 ) ;
      ~CCompletion() ;
      /*-------------------------------------------------------------------*/
      struct str_var_desc
      {
         const char *co_p_c_var  ;
         const char *co_p_c_desc ;
         const char *co_p_c_help ;
      } ;

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      wxWindow          *m_p_parent    ; // Parent control
      wxTextCtrl        *m_p_textctrl  ; // Associated control
      wxToolBarToolBase *m_p_to_btn    ; // Associated toolbar button
      wxMenuItem        *m_p_menu_item ; // Associated menu item

      /*--------------------------------------------------------------------+
      ! Outside address of this object                                      !
      ! Used for "singleton" purpose and access to properties/functions     !
      +--------------------------------------------------------------------*/
      CCompletion *&m_p_saved_addr ;
      /*-------------------------------------------------------------------*/
      CConfigRect &m_cfg_rec       ; // Window coordinates and sizes
      wxNotebook  *m_nb            ;
      /*-------------------------------------------------------------------*/
      typedef std::vector< CCompletionList * > t_vec_pt_list ;
      t_vec_pt_list m_vec_list ;

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CCompletionList *create_page( const wxString &s_title,
                                    const wxString &s_def_help_file
                                  ) ;
      /*-------------------------------------------------------------------*/
      void add_page( const wxString &s_title, const str_var_desc *p_vd,
                     const wxString &s_def_help_file
                   ) ;
      void add_page( int i_grp, const str_var_desc *p_vd,
                     const wxString &s_def_help_file
                   ) ;
      void add_page_env_var( const wxString &s_title ) ;
      /*-------------------------------------------------------------------*/
      void init() ;
      void assign_focus() ;
      void show_current_var() ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CCOMPLETION_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CCompletion.h                            !
+==========================================================================*/
