/*====================================+=====================================+
! File CColGroup.h                    ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CCOLGROUP_H
#define CCOLGROUP_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/toolbar.h>
/*-------------------------------------------------------------------------*/
#include "siren.h"
#include "CConfig.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CColGroup
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CColGroup()  ;
      ~CColGroup() ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      struct str_group
      {
         /*----------------------------------------------------------------*/
         str_group() : m_i_id_bt( -1 ), m_boo_used( false )
         {  ; }
         /*----------------------------------------------------------------*/
         wxString    m_s_name        ; // Name of the group
         int         m_i_id_bt       ; // Id of the button
         wxString    m_s_var_name    ; // Name on wxConfig variable
         wxString    m_s_help_anchor ; // Help entry associated to this group
         CConfigBool M_cb_checked    ; // Group checked (user/automatically)?
         const char * const *m_xpm   ; // Button image
         /*----------------------------------------------------------------*/
         bool        m_boo_used    ; // Some non empty cols belong this grp ?
         /*----------------------------------------------------------------*/
         wxString get_help_text()
         {  /*-------------------------------------------------------------*/
            return( wxString::Format( _( "Display the columns of the "
                                         "group \"%s\" checked in "
                                         "the preferences"
                                       ),
                                      m_s_name
                                    )
                  ) ;
            /*-------------------------------------------------------------*/
         }
         /*----------------------------------------------------------------*/
      } ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      str_group m_tb_group[ GRP_NB ] ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      bool get_grp_ok( int i_grp ) const
      {  return( i_grp >= 0 && i_grp < GRP_NB ) ; }
      /*-------------------------------------------------------------------*/
      wxString get_name( int i_grp ) const
      {  if( get_grp_ok( i_grp ) )
         {  return( m_tb_group[ i_grp ].m_s_name ) ; }
         return( wxEmptyString ) ;
      }
      /*-------------------------------------------------------------------*/
      wxString get_var_name( int i_grp ) const
      {  if( get_grp_ok( i_grp ) )
         {  return( m_tb_group[ i_grp ].m_s_var_name ) ; }
         return( wxEmptyString ) ;
      }
      /*-------------------------------------------------------------------*/
      wxString get_help_anchor( int i_grp ) const
      {  if( get_grp_ok( i_grp ) )
         {  return( m_tb_group[ i_grp ].m_s_help_anchor ) ; }
         return( wxEmptyString ) ;
      }
      /*-------------------------------------------------------------------*/
      bool get_used( int i_grp ) const
      {  return( get_grp_ok( i_grp )
                 ? m_tb_group[ i_grp ].m_boo_used : false
               ) ;
      }
      void set_used( int i_grp, bool boo_val )
      {  if( get_grp_ok( i_grp ) )
         {  m_tb_group[ i_grp ].m_boo_used = boo_val ; }
      }
      /*-------------------------------------------------------------------*/
      bool has_button( int i_grp ) const
      {  return( get_grp_ok( i_grp )
                 ? m_tb_group[ i_grp ].m_i_id_bt > 0 : false
               ) ;
      }
      /*--( No button associated to the group => displayed )---------------*/
      bool to_display( int i_grp ) const
      {  return( get_grp_ok( i_grp ) && has_button( i_grp )
                 ? m_tb_group[ i_grp ].M_cb_checked.get() : true
               ) ;
      }
      /*-------------------------------------------------------------------*/
      bool get_checked( int i_grp ) const
      {  return( get_grp_ok( i_grp )
                 ? m_tb_group[ i_grp ].M_cb_checked.get() : true
               ) ;
      }
      /*-------------------------------------------------------------------*/
      const char * const *get_xpm( int i_grp ) const
      {  return( get_grp_ok( i_grp ) ? m_tb_group[ i_grp ].m_xpm : NULL ) ; }
      /*-------------------------------------------------------------------*/
      void init_names() ;
      int get_id_bt_grp( int i_id_bt ) const ;
      void add_buttons( wxToolBar *p_tb ) ;
      void synchro_used_disp_button() ;
      /*-------------------------------------------------------------------*/
      void init_var() ;
      void save_var() ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CCOLGROUP_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                         End of file CColGroup.h                           !
+==========================================================================*/
