/*====================================+=====================================+
! File CCheckVersion.h                ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+---------------------------------------------------------------------------+
!                                                                           !
!               Check if a new version of Siren is available                !
!                                                                           !
+-------+-------------------------------------------------------------------+
! Notes !                                                                   !
+-------+                                                                   !
! After many tests the solution found for startup checks is a wxHTTP access !
! through a thread.                                                         !
! The small issue is that the minimal timeout is 1 second. So if a check is !
! threaded it might be stopped only after 1 second ...                      !
! At least under MSW, if a thread is running, the main frame can't be       !
! closed.                                                                   !
!                                                                           !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CCHECKVERSION_H
#define CCHECKVERSION_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CThreadCheckVersion ;

/*-------------------------------------------------------------------------*/
class CCheckVersion
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CCheckVersion() ;
      ~CCheckVersion() ;

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      enum e_ret_code
      {  CVC_ERROR,
         CVC_LAST_VERSION,
         CVC_NEW_VERSION
      } ;
      /*-------------------------------------------------------------------*/
      enum e_exec_mode
      {  EM_THREADED,
         EM_NON_THREADED
      } ;
      /*-------------------------------------------------------------------*/
      CThreadCheckVersion *m_p_thread ;
      wxCriticalSection   m_csec_p_thread ;
      bool                m_boo_thread_stopping ;

   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      e_ret_code exec( e_exec_mode exec_mode, wxString &s_info ) ;

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      e_ret_code non_threaded_exec( wxString &s_info ) ;
      void thread_start() ;
      void thread_stop() ;
      /*-------------------------------------------------------------------*/
      bool thread_running() ;

   /*----------------------------------------------------------------------*/
   friend class CThreadCheckVersion ;
   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/
class CThreadCheckVersion : public wxThread
{
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CThreadCheckVersion( CCheckVersion *p_cv ) ;
      ~CThreadCheckVersion() ;
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      CCheckVersion    *m_p_cv ;
      e_send_end_event m_seevt ;
   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      e_send_end_event get_send_end_event() const
      {  return( m_seevt ) ; }
      void set_send_end_event( e_send_end_event seevt )
      {  m_seevt = seevt ; }
      /*--( Will be executed by "Run" )------------------------------------*/
      virtual wxThread::ExitCode Entry() ;

   /*----------------------------------------------------------------------*/
} ;

/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CCHECKVERSION_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                      End of file CCheckVersion.h                          !
+==========================================================================*/
