/*====================================+=====================================+
! File CApp.h                         ! Copyright (C) 2002-2013 Remi PASCAL !
+-------------------------------------+-------------------------------------+
! This file is part of Siren.                                               !
! Siren is free software: you can redistribute it and/or modify it under    !
! the terms of the GNU General Public License as published by the Free      !
! Software Foundation, either version 3 of the License, or any later        !
! version.                                                                  !
! Siren is distributed in the hope that it will be useful, but WITHOUT ANY  !
! WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS !
! FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more    !
! details.                                                                  !
! You should have received a copy of the GNU General Public License along   !
! with Siren. If not, see <http://www.gnu.org/licenses/>.                   !
+==========================================================================*/



/*-------------------------------------------------------------------------*/
#ifndef CAPP_H
#define CAPP_H
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#include <wx/cmdline.h>
#include <wx/app.h>
/*-------------------------------------------------------------------------*/
#include "CConfig.h"
#include "CColGroup.h"
#include "dynmenu/CFavourite.h"
#include "dynmenu/CTool.h"
#include "CFrame.h"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
class CApp : public wxApp
{
   /*----------------------------------------------------------------------*/
   private :
      /*-------------------------------------------------------------------*/
      bool          m_boo_init_done           ; // OnInit function finished ?
      bool          m_boo_first_start_ever    ; // Siren never started ?
      /*-------------------------------------------------------------------*/
      wxLocale      m_locale                  ; // Default main locale object
      wxString      m_s_system_canonical_name ;
      wxArrayString m_as_locale_path          ; // Paths to translation files
      wxString      m_s_exe_path              ;
      bool          m_boo_default_config_file ;
      wxString      m_s_config_filename       ;
      bool          m_boo_cmdline_save_config ;
      bool          m_boo_cmdline_recurse     ;
      wxString      m_s_cmdline_sel_filter    ;
      e_otfile      m_cmdline_otfile          ; // Operation to do on files
      bool          m_boo_cmdline_quit        ; // Quitting requested
      wxString      m_s_cmdline_dir           ;
      wxArrayString m_as_cmdline_file         ;
      bool          m_boo_cmdline_dir_loaded  ; // Expected dir loaded ?

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      CFrame        *m_frame ;

   /*----------------------------------------------------------------------*/
   public :
      /*--------------------------------------------------------------------+
      ! Members of classes with "serialized" members                        !
      +--------------------------------------------------------------------*/
      CColGroup          m_colgroup            ;
      CFavourite         m_favourite           ;
      CTool              m_tool                ;
      /*--------------------------------------------------------------------+
      ! Serialized variables                                                !
      +--------------------------------------------------------------------*/
      CConfigBool        M_boo_toolbar_grp     ;
      CConfigBool        M_boo_three_toolbars  ;
      CConfigInt         M_i_layout            ;
      CConfigBool        M_boo_show_statusbar  ;
      CConfigBool        M_boo_thumbnail       ; // Disp thumbnail/full image
      /*-------------------------------------------------------------------*/
      CConfigInt         M_i_spl_ver_pos       ;
      CConfigInt         M_i_spl_hor_pos       ;
      /*-------------------------------------------------------------------*/
      CConfigRect        M_rec_main            ;
      CConfigRect        M_rec_completion      ; // Main completion
      CConfigRect        M_rec_completion_tb   ; // Testbed completion
      CConfigRect        M_rec_prefs           ; // Preferences
      CConfigRect        M_rec_wizard          ;
      CConfigRect        M_rec_testbed         ;
      CConfigRect        M_rec_filter          ;
      CConfigRect        M_rec_filter_search   ;
      CConfigRect        M_rec_manren          ; // Manual rename
      /*-------------------------------------------------------------------*/
      CConfigBool        M_boo_main_maxi       ;
      CConfigInt         M_nb_sel_page         ;
      CConfigInt         M_i_sort_subitem      ;
      CConfigBool        M_boo_sort_asc        ;
      CConfigString      M_s_exp               ;
      CConfigString      M_s_dir               ;
      CConfigString      M_s_fil               ;
      CConfigString      M_s_opfil             ;
      CConfigArrayString M_as_exp              ;
      CConfigArrayString M_as_dir              ;
      CConfigArrayString M_as_fil              ;
      CConfigArrayString M_as_opfil            ;
      CConfigBool        M_boo_opfil_dir       ;
      CConfigBool        M_boo_opfil_match     ;
      /*-------------------------------------------------------------------*/
      CConfigString      M_s_lang              ; // Canonical name: en_US ...
      CConfigBool        M_boo_chkver_auto     ;
      CConfigString      M_s_last_chkver_auto  ;
      CConfigBool        M_boo_extr_meta       ; // Extract metadata ?
      CConfigBool        M_boo_file_type_detect; // File type detection ?
      CConfigBool        M_boo_loose_mp3_check ; // mp3 loose check analyse
      CConfigBool        M_boo_copy_file_tms   ;
      /*-------------------------------------------------------------------*/
      CConfigBool        M_boo_list_alt_attr   ; // Altern color background ?
      CConfigBool        M_boo_grid_fl         ;
      CConfigBool        M_boo_list_hidden     ;
      CConfigBool        M_boo_natural_sort    ;
      CConfigBool        M_boo_fsizeb_fl       ;
      CConfigBool        M_boo_list_dir        ;
      CConfigBool        M_boo_list_dir_top    ;
      CConfigBool        M_boo_filter_dir      ;
      CConfigBool        M_boo_dir_size_fl     ;
      CConfigBool        M_boo_img_rotation    ;
      CConfigBool        M_boo_img_hq_manip    ;
      CConfigBool        M_boo_img_stretch     ;
      CConfigBool        M_boo_exp_fix         ;
      CConfigBool        M_boo_fil_fix         ;
      CConfigString      M_s_fmt_date_fl       ;
      /*-------------------------------------------------------------------*/
      CConfigTabString   M_tb_col              ;
      CConfigBool        M_boo_grp_auto        ;
      CConfigBool        M_boo_col_used        ;
      /*--( Clipboard data copy )------------------------------------------*/
      CConfigBool        M_boo_cbc_sep_tab     ; // Cols separated by tabs ?
      CConfigString      M_s_cbc_sep_char      ; // Cols separation char
      CConfigString      M_s_cbc_repl_sep_char ; // Separat char replacement
      /*-------------------------------------------------------------------*/
      CConfigBool        M_boo_imm_recompute   ; // Change exp => recompute ?
      CConfigBool        M_boo_exp_dir_ext     ; // Treat extension for dirs?
      CConfigBool        M_boo_id3v1aud_nvl    ;
      CConfigString      M_s_chars_tab_sep     ;
      CConfigString      M_s_chars_word_sep    ;
      CConfigInt         M_i_max_name_len      ;
      /*-------------------------------------------------------------------*/
      CConfigString      M_s_del_chars         ;
      CConfigString      M_s_del_repeat_chars  ;
      CConfigString      M_s_rep_chars_from    ;
      CConfigString      M_s_rep_chars_to      ;
      CConfigString      M_s_rep_char_inv      ;
      /*-------------------------------------------------------------------*/
      CConfigBool        M_boo_force_case_word ;
      CConfigArrayString M_as_force_case_word  ;
      /*-------------------------------------------------------------------*/
      CConfigInt         M_i_sel_num_pad       ;
      CConfigInt         M_i_sel_num_beg       ;
      CConfigInt         M_i_sel_num_inc       ;
      CConfigInt         M_i_num_in_name_pad   ;
      CConfigInt         M_i_num_in_name_add   ;
      CConfigInt         M_i_track_pad         ;
      CConfigInt         M_i_rand_len          ;
      /*-------------------------------------------------------------------*/
      CConfigString      M_s_fmt_date          ;
      CConfigString      M_s_fmt_time          ;
      CConfigString      M_s_fmt_date_time     ;
      CConfigInt         M_i_fmt_date_add      ;
      /*-------------------------------------------------------------------*/

   /*----------------------------------------------------------------------*/
   public :
      /*-------------------------------------------------------------------*/
      virtual bool OnInit() ;
      virtual void OnInitCmdLine( wxCmdLineParser &parser ) ;
      virtual bool OnCmdLineParsed( wxCmdLineParser &parser ) ;
      void OnEventLoopEnter( wxEventLoopBase *loop ) ;
      void init_config_info() ;
      void save_config_info() ;
      /*-------------------------------------------------------------------*/
      bool get_init_done() const
      {  return( m_boo_init_done ) ; }
      bool get_first_start_ever() const
      {  return( m_boo_first_start_ever ) ;}
      wxToolBar *get_tb_grp()
      {  return( m_frame->m_to_grp ) ; }
      CFileList *get_fl()
      {  return( m_frame->m_fl ) ; }
      const wxString &get_exe_path() const
      {  return( m_s_exe_path ) ; }
      const bool get_cmdline_save_config() const
      {  return( m_boo_cmdline_save_config ) ; }
      bool get_default_config_file() const
      {  return( m_boo_default_config_file ) ; }
      wxString get_config_filename() const
      {  return( m_s_config_filename ) ;}
      const wxArrayString &get_locale_path() const
      {  return( m_as_locale_path ) ; }
      wxString get_system_canonical_name() const
      {  return( m_s_system_canonical_name ) ; }
      wxString get_canonical_name() const
      {  return( M_s_lang.empty()
                 ? m_s_system_canonical_name : M_s_lang.get()
               ) ;
      }
      /*-------------------------------------------------------------------*/
      wxString get_disp_fmt_date()
      {  return( M_s_fmt_date_fl.empty()
                 ? wxDefaultDateTimeFormat : M_s_fmt_date_fl.get()
               ) ;
      }
      /*-------------------------------------------------------------------*/
      bool is_path_ok_to_read( const wxString &s_path ) ;
      int startup_load_directory() ;
      int apply_cmdline_oper() ;
      /*-------------------------------------------------------------------*/
      void init_vars_from_command_line( wxCmdLineParser &parser ) ;
      wxString translated_file_path( const wxString &s_filename ) ;
      /*--( Top Level Windows size and position )--------------------------*/
      void tlw_set_rect( wxWindow *p_win, const wxRect &rect ) ;
      void init_tlw_rect( wxWindow *p_win, const CConfigRect &cfg_rect ) ;
      void save_tlw_rect( wxWindow *p_win, CConfigRect &cfg_rect ) ;

   /*----------------------------------------------------------------------*/
} ;


/*-------------------------------------------------------------------------*/
DECLARE_APP( CApp )
/*-------------------------------------------------------------------------*/
DECLARE_EVENT_TYPE( EVT_SR_LOADDIR_END, -1 )
DECLARE_EVENT_TYPE( EVT_SR_CHECKVERSION_AUTO_END, -1 )
DECLARE_EVENT_TYPE( EVT_SR_DISP_INFO, -1 )
DECLARE_EVENT_TYPE( EVT_SR_SET_BT_STOP_LOADING, -1 )
DECLARE_EVENT_TYPE( EVT_SR_CLEAR_FILE_LIST, -1 )

/*--( Help file names )----------------------------------------------------*/
#define HELP_USER  "user_interface.htm"
#define HELP_EXP   "exp.htm"
#define HELP_FIL   "filters.htm"
#define HELP_VAR   "exp_variables.htm"
#define HELP_MOD   "exp_modifiers.htm"
#define HELP_ADV   "exp_advanced.htm"
#define HELP_DATE  "exp_date.htm"
/*-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*/
#endif // CAPP_H
/*-------------------------------------------------------------------------*/



/*==========================================================================+
!                            End of file CApp.h                             !
+==========================================================================*/
